float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4	g_light;
float4	g_camera_eye_vector;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;
texture g_tex0;

float g_sinf;
float g_sinfrand;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
     Texture = (g_tex0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

struct OutputVS
{
	float4 posH		: POSITION;
	float2 UV		: TEXCOORD0;
	float3 Norm		: TEXCOORD1;
};

OutputVS SpecularVS( float4 posL : POSITION , float3 normal : NORMAL , float2 UV : TEXCOORD0 )
{
	OutputVS outVS = (OutputVS)0;

	float3 poss;
	poss.x = posL.x  + ((abs(posL.x) + 1.0f) * cos((posL.y + g_sinf + g_sinfrand) * 0.5f)) * 0.75;
	poss.z = posL.z  + ((abs(posL.z) + 1.0f) * sin((posL.y + g_sinf + g_sinfrand) * 0.5f)) * 0.75;
	poss.y = posL.y;


	outVS.posH = mul( float4(poss, 1.0f) , g_world_matrix );
	outVS.posH = mul( outVS.posH , g_view_projection_matrix );
	
	outVS.UV = UV;	

	outVS.Norm = mul( normal , g_world_matrix );

	return outVS;
}

float4 SpecularPS( float2 UV : TEXCOORD0, float3 Norm : TEXCOORD1 ) : COLOR
{
	float ndl = abs(dot(Norm, normalize(float3(-1, -1, -1))));
	float3 Diff = float3(0.5, 0.5, 0.5) * ndl;
	
	return float4( Diff * tex2D( tex0, UV ).xyz * 2.5, 1.0f);
}

technique normal
{
	pass p0
	{
		vertexShader = compile vs_2_0 SpecularVS();
		pixelShader = compile ps_2_0 SpecularPS();
	}
}